/*********************Gallery***********************/
 

const body = document.body;
const galleryTabs = document.querySelectorAll('.gallery_tabs li');
const galleryItems = document.querySelectorAll('.gallery_item');
const galleryImgs = document.querySelectorAll('.gallery_item img');
const lightbox = document.querySelector('.lightbox');
const lightboxImg = document.querySelector('.lightbox_img');
const lightboxCloseBtn = document.querySelector('.lightbox_close');


galleryTabs.forEach((currTab) => {
    currTab.addEventListener('click', (e) => {

        // removing the existing 'active' class from the tabs.
        e.target.parentElement.querySelector('.active').classList.remove('active');

        // adding the 'active' class to the currently clicked tab.
        e.target.classList.add('active');


        let filterValue = e.target.getAttribute('data-filter');

        galleryItems.forEach((currItem) => {
            if (filterValue === 'all' || currItem.classList.contains(filterValue)) {
                currItem.classList.remove('hide');
                currItem.classList.add('show');
            }
            else {
                currItem.classList.remove('show');
                currItem.classList.add('hide');
            }
        });

    });
});

 galleryImgs.forEach((currImg) => {
      currImg.addEventListener('click', (e) => {

          let imgSrc = e.target.getAttribute('src');

          lightboxImg.setAttribute('src', imgSrc);

          lightbox.classList.add('open');
          body.classList.add('overflow_hide');

      });
  });

  const lightboxClose = () => {
      lightbox.classList.remove('open');
      body.classList.remove('overflow_hide');
  };

  lightboxCloseBtn.addEventListener('click', lightboxClose);

  window.addEventListener('click', (e) => {
      if (e.target.className === 'lightbox_wrapper') {
          lightboxClose();
      }
  });

  window.addEventListener('keydown', (e) => {
      if (e.key === 'Escape') {
          lightboxClose();
      }
  });

  document.addEventListener('DOMContentLoaded', function () {
    const galleryItems = document.querySelectorAll('.gallery_item img');
    const lightbox = document.querySelector('.lightbox');
    const lightboxImg = document.querySelector('.lightbox_img');
    const closeBtn = document.querySelector('.lightbox_close');
    const prevBtn = document.querySelector('.prev');
    const nextBtn = document.querySelector('.next');
    let currentIndex = 0;

    function openLightbox(index) {
        currentIndex = index;
        lightboxImg.src = galleryItems[index].src;
        lightbox.style.display = 'block';
    }

    function closeLightbox() {
        lightbox.style.display = 'none';
    }

    function showPrevImage() {
        currentIndex = (currentIndex > 0) ? currentIndex - 1 : galleryItems.length - 1;
        lightboxImg.src = galleryItems[currentIndex].src;
    }

    function showNextImage() {
        currentIndex = (currentIndex < galleryItems.length - 1) ? currentIndex + 1 : 0;
        lightboxImg.src = galleryItems[currentIndex].src;
    }

    galleryItems.forEach((item, index) => {
        item.addEventListener('click', () => openLightbox(index));
    });

    closeBtn.addEventListener('click', closeLightbox);
    prevBtn.addEventListener('click', showPrevImage);
    nextBtn.addEventListener('click', showNextImage);
});
