"use strict";

		window.addEventListener("DOMContentLoaded", function () {
			const modalOpenBtn = document.querySelectorAll("[data-modal]");
			const modal = document.querySelector(".modal"),
				modalCloseBtn = document.querySelectorAll("[data-close]");

			function openModal() {
				// modal.classList.add("hide");
				// modal.classList.remove("show");
				modal.classList.toggle("show");
				document.body.style.overflow = "hidden";
				clearInterval(modalTimerId);
			}

			modalOpenBtn.forEach((btn) => {
				btn.addEventListener("click", openModal);
			});

			function closeModal() {
				// modal.classList.add("hide");
				// modal.classList.remove("show");
				modal.classList.toggle("show");
				document.body.style.overflow = "";
			}

			//Закрырие крестиком
			modalCloseBtn.forEach((btn) => {
				btn.addEventListener("click", closeModal);
			});

			//Закрырие по клику за пределами окна
			modal.addEventListener("click", (e) => {
				if (e.target === modal) {
					closeModal();
				}
			});

			//Закрырие ESC
			document.addEventListener("keydown", (e) => {
				if (e.code === "Escape" && modal.classList.contains("show")) {
					closeModal();
				}
			});

			//Открытие окна через ...
			const modalTimerId = setTimeout(openModal, 3000);

			//Открытие окна  при прокрутке до низу
			function showModalByScroll() {
				if (
					window.pageYOffset + document.documentElement.clientHeight >=
					document.documentElement.scrollHeight - 50
				) {
					openModal();
					window.removeEventListener("scroll", showModalByScroll);
				}
			}

			window.addEventListener("scroll", showModalByScroll);
		});